*                                                                                  ;
 *    Reading in the 1977 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam77.raw' ;
 
 data one;
 
   infile 'F:\PSID\77FAM.DAT'  lrecl=942 missover;
   INPUT
    V5201 1-3              V5202 4-7              V5203 8-9
    V5204 10-12            V5205 13-17            V5206 18
    V5207 19               V5208 20               V5209 21
    V5210 22               V5211 23               V5212 24
    V5213 25               V5214 26               V5215 27
    V5216 28               V5217 29-34            V5218 35
    V5219 36-40            V5220 41               V5221 42-45
    V5222 46               V5223 47               V5224 48-51
    V5225 52-55            V5226 56               V5227 57
    V5228 58               V5229 59-62            V5230 63
    V5231 64-67            V5232 68-71            V5233 72
    V5234 73-76            V5235 77               V5236 78-81
    V5237 82               V5238 83-86            V5239 87
    V5240 88-91            V5241 92               V5242 93-95
    V5243 96               V5244 97-100           V5245 101
    V5246 102-105          V5247 106              V5248 107-110
    V5249 111              V5250 112-115          V5251 116
    V5252 117-120          V5253 121              V5254 122-123
    V5255 124              V5256 125-129 .2       V5257 130-134
    V5258 135-138          V5259 139-142          V5260 143-146
    V5261 147              V5262 148-151          V5263 152
    V5264 153-156          V5265 157              V5266 158
    V5267 159-161          V5268 162              V5269 163-165
    V5270 166              V5271 167-170          V5272 171
    V5273 172-175          V5274 176              V5275 177-180
    V5276 181              V5277 182-185          V5278 186
    V5279 187-188          V5280 189              V5281 190-194
    V5282 195-199          V5283 200-204          V5284 205
    V5285 206-210          V5286 211-215          V5287 216-219
    V5288 220              V5289 221-225          V5290 226
    V5291 227-231          V5292 232-236          V5293 237-240
    V5294 241-244          V5295 245-249          V5296 250-254
    V5297 255-259          V5298 260              V5299 261-265
    V5300 266              V5301 267-271          V5302 272-273
    V5303 274-278          V5304 279              V5305 280-284
    V5306 285-289          V5307 290-294          V5308 295-299
    V5309 300-303          V5310 304-308          V5311 309-312
    V5312 313-316          V5313 317-320          V5314 321-325
    V5315 326              V5316 327-331          V5317 332-335
    V5318 336-340          V5319 341              V5320 342
    V5321 343-347          V5322 348-352          V5323 353-357
    V5324 358-362          V5325 363-367          V5326 368-372
    V5327 373-376          V5328 377-381          V5329 382-386
    V5330 387-390          V5331 391-394          V5332 395-399
    V5333 400              V5334 401              V5335 402
    V5336 403-406          V5337 407-410          V5338 411-414
    V5339 415-418          V5340 419-422          V5341 423-426
    V5342 427-430          V5343 431-434          V5344 435-438
    V5345 439-447          V5346 448-449          V5347 450
    V5348 451-453          V5349 454-455          V5350 456-457
    V5351 458              V5352 459-460          V5353 461-462
    V5354 463-464          V5355 465              V5356 466
    V5357 467              V5358 468              V5359 469
    V5360 470              V5361 471-475          V5362 476
    V5363 477              V5364 478              V5365 479
    V5366 480              V5367 481-482          V5368 483
    V5369 484              V5370 485              V5371 486
    V5372 487              V5373 488              V5374 489-490
    V5375 491-492          V5376 493              V5377 494
    V5378 495              V5379 496              V5380 497-498
    V5381 499              V5382 500              V5383 501
    V5384 502-504          V5385 505              V5386 506
    V5387 507              V5388 508-509          V5389 510
    V5390 511              V5391 512              V5392 513-515
    V5393 516              V5394 517-518          V5395 519
    V5396 520-521          V5397 522-524          V5398 525-526
    V5399 527              V5400 528              V5401 529
    V5402 530              V5403 531              V5404 532
    V5405 533-534          V5406 535              V5407 536-537
    V5408 538-539          V5409 540              V5410 541-542
    V5411 543              V5412 544-545          V5413 546
    V5414 547-548          V5415 549              V5416 550
    V5417 551-552          V5418 553-554          V5419 555
    V5420 556              V5421 557-559          V5422 560
    V5423 561-563          V5424 564-566          V5425 567-569
    V5426 570              V5427 571-573          V5428 574
    V5429 575-576          V5430 577              V5431 578-580
    V5432 581-582          V5433 583-584          V5434 585
    V5435 586-588          V5436 589              V5437 590
    V5438 591              V5439 592-593          V5440 594
    V5441 595-596          V5442 597-599          V5443 600
    V5444 601              V5445 602              V5446 603
    V5447 604              V5448 605              V5449 606-608
    V5450 609              V5451 610-612          V5452 613
    V5453 614-615          V5454 616              V5455 617-618
    V5456 619-620          V5457 621              V5458 622
    V5459 623-624          V5460 625              V5461 626-627
    V5462 628              V5463 629              V5464 630-631
    V5465 632              V5466 633-634          V5467 635
    V5468 636-637          V5469 638              V5470 639-640
    V5471 641              V5472 642              V5473 643-644
    V5474 645-646          V5475 647-648          V5476 649
    V5477 650              V5478 651              V5479 652
    V5480 653              V5481 654-655          V5482 656-657
    V5483 658-659          V5484 660-661          V5485 662-663
    V5486 664              V5487 665              V5488 666
    V5489 667-668          V5490 669              V5491 670
    V5492 671-673          V5493 674              V5494 675
    V5495 676              V5496 677              V5497 678
    V5498 679              V5499 680              V5500 681
    V5501 682-684          V5502 685              V5503 686
    V5504 687              V5505 688              V5506 689
    V5507 690-691          V5508 692-693          V5509 694
    V5510 695              V5511 696-697          V5512 698
    V5513 699-700          V5514 701              V5515 702-703
    V5516 704              V5517 705-706          V5518 707
    V5519 708-709          V5520 710              V5521 711
    V5522 712-713          V5523 714-715          V5524 716
    V5525 717              V5526 718              V5527 719
    V5528 720-721          V5529 722              V5530 723-724
    V5531 725              V5532 726              V5533 727
    V5534 728-729          V5535 730-731          V5536 732
    V5537 733              V5538 734              V5539 735
    V5540 736              V5541 737              V5542 738
    V5543 739              V5544 740              V5545 741
    V5546 742              V5547 743              V5548 744
    V5549 745              V5550 746              V5551 747
    V5552 748              V5553 749              V5554 750
    V5555 751              V5556 752              V5557 753
    V5558 754              V5559 755              V5560 756
    V5561 757              V5562 758              V5563 759
    V5564 760              V5565 761-762          V5566 763
    V5567 764-765          V5568 766              V5569 767
    V5570 768              V5571 769              V5572 770
    V5573 771              V5574 772-773          V5575 774-775
    V5576 776-777          V5577 778              V5578 779
    V5579 780-781          V5580 782-784          V5581 785-786
    V5582 787-789          V5583 790              V5584 791
    V5585 792              V5586 793-794          V5587 795-796
    V5588 797-798          V5589 799-800          V5590 801
    V5591 802              V5592 803              V5593 804
    V5594 805-806          V5595 807-809          V5596 810
    V5597 811              V5598 812              V5599 813
    V5600 814              V5601 815              V5602 816
    V5603 817              V5604 818-819          V5605 820-821
    V5606 822-823          V5607 824              V5608 825-826
    V5609 827              V5610 828              V5611 829
    V5612 830              V5613 831              V5614 832
    V5615 833              V5616 834              V5617 835
    V5618 836              V5619 837              V5620 838
    V5621 839-841          V5622 842              V5623 843-845
    V5624 846              V5625 847              V5626 848-852
    V5627 853-857          V5628 858-862          V5629 863-866 .2
    V5630 867-870          V5631 871-874 .2       V5632 875-878 .2
    V5633 879              V5634 880              V5635 881
    V5636 882              V5637 883              V5638 884
    V5639 885-886          V5640 887-888          V5641 889-893
    V5642 894              V5643 895-896 .1       V5644 897-898
    V5645 899              V5646 900              V5647 901
    V5648 902              V5649 903-905          V5650 906
    V5651 907              V5652 908              V5653 909
    V5654 910              V5655 911              V5656 912
    V5657 913              V5658 914              V5659 915
    V5660 916              V5661 917              V5662 918
    V5663 919              V5664 920              V5665 921-922
    V5666 923              V5667 924              V5668 925
    V5669 926              V5670 927              V5671 928
    V5672 929              V5673 930              V5674 931
    V5675 932              V5676 933              V5677 934
    V5678 935              V5679 936              V5680 937
    V5681 938-941          V5682 942;

 * SAS LABEL STATEMENT;

 LABEL
    V5201 = "STUDY # 768 WAVE 10"
    V5202 = "1977 ID"
    V5203 = "CURRENT STATE 1977"
    V5204 = "CURRENT COUNTY 1977"
    V5205 = "CURRENT ST& CNTY 1977"
    V5206 = "SIZE LGST PLACE SMSA 77"
    V5207 = "COLOR OF COVERSHEET  77"
    V5208 = "WHETHER REFUSED 1977"
    V5209 = "TELEPHONE INT 1977"
    V5210 = "FAM COMP CHNG 1977"
    V5211 = "# MOVED IN 1977"
    V5212 = "WHO MOVED IN 1977"
    V5213 = "# MOVED OUT 1977"
    V5214 = "WHO MOVED OUT 1977"
    V5215 = "CURRENT FAM COMP 1977"
    V5216 = "QUALITY OF MATCH 1977"
    V5217 = "1977 HOUSE VALUE (C5)"
    V5218 = "ACC 77 HOUSE VALUE"
    V5219 = "REM MORT PRIN 77 (C7)"
    V5220 = "ACC REM MORT PRIN"
    V5221 = "ANNUAL MORT $  1977 (C8)"
    V5222 = "ACC ANN MORT $"
    V5223 = "TAX INCL IN C8?  (C11)"
    V5224 = "ANNUAL PROPERT TAX (C12)"
    V5225 = "ANNUAL RENT 1977 (C13)"
    V5226 = "ACC ANN RENT"
    V5227 = "RENT FURNISHED? (C14)"
    V5228 = "RENT HEATED?    (C17)"
    V5229 = "ANNUAL $  IF RENTED (C19)"
    V5230 = "ACC ANN $  IF RENTED"
    V5231 = "ANNUAL UTILITIES $  IN 76"
    V5232 = "HD ANN WRK HRS IN 76"
    V5233 = "ACC HD 76 WRK HRS"
    V5234 = "HD HRS WRK LOST OTH ILL"
    V5235 = "ACC HD HR LOST OTH ILL"
    V5236 = "HD HRS WRK LOST OWN ILL"
    V5237 = "ACC HD HR LOST OWN ILL"
    V5238 = "HEAD STRIKE HOURS 76"
    V5239 = "ACC HD STRIKE HRS 76"
    V5240 = "HEAD UNEMPLMT HRS 76"
    V5241 = "ACC HD UNEMPLNT HRS 76"
    V5242 = "HEAD TRAV TO WORK HRS 76"
    V5243 = "ACC HD TRAV TO WRK HR 76"
    V5244 = "WIFE ANN WORK HOURS 1976"
    V5245 = "ACC WIFE WORK HRS  1976"
    V5246 = "WF HRS WRK LOST OTH ILL"
    V5247 = "ACC WF HR LOST OTH ILL"
    V5248 = "WF HRS WRK LOST OWN ILL"
    V5249 = "ACC WF HR LOST OWN ILL"
    V5250 = "WIFE STRIKE HOURS 1976"
    V5251 = "ACC WF STRIKE HRS 1976"
    V5252 = "WIFE UNEMPLMNT HRS 76"
    V5253 = "ACC WF UNEMPLMNT HR 76"
    V5254 = "1977 FAMILY SIZE"
    V5255 = "# REQUIRED ROOMS 1977"
    V5256 = "1977 WEEKLY FOOD NEED"
    V5257 = "1977 ANNUAL NEED STD"
    V5258 = "ANN CHILDCARE HRS (G26)"
    V5259 = "ANN CHILDCARE $    (G28)"
    V5260 = "WIFE HSEWORK HRS  (G32)"
    V5261 = "ACC WF HSEWORK HRS"
    V5262 = "HEAD HSEWORK HRS  (G33)"
    V5263 = "ACC HD HSEWORK HRS"
    V5264 = "OTHER HSEWORK HRS (G37)"
    V5265 = "ACC OTH HSEWORK HRS"
    V5266 = "# USED FD STAMP LAST MO"
    V5267 = "$  PAID FD STAMP LAST MO"
    V5268 = "ACC $ PD FD STAMP LAST MO"
    V5269 = "$  BONUS FD STAMP LAST MO"
    V5270 = "ACC $ BONUS FDSTMP LASTMO"
    V5271 = "ANNUAL FOOD$  EXCL FDSTMP"
    V5272 = "ACC ANN FOOD $"
    V5273 = "ANNUAL $  EATING OUT"
    V5274 = "ACC ANN $  EATING OUT"
    V5275 = "$  PAID FD STAMPS 1976"
    V5276 = "ACC $  PAID FD STAMPS  76"
    V5277 = "BONUS $  FD STAMPS 1976"
    V5278 = "ACC BONUS $  FDSTAMS 1976"
    V5279 = "# MONTHS USED STAMPS  76"
    V5280 = "# MAJOR ADULTS 1977"
    V5281 = "LABOR PART FARM Y 1976"
    V5282 = "LABOR PART BUS  Y 1976"
    V5283 = "HEAD 1976 WAGES"
    V5284 = "ACC HEAD 1976 WAGES"
    V5285 = "HD BONUS,OT,COMM 1976"
    V5286 = "HD PROF PRAC/TRADE 1976"
    V5287 = "LAB PART ROOMERS 1976"
    V5288 = "ACC HD LABOR Y EXCL WAGE"
    V5289 = "WIFE 1976 WAGES"
    V5290 = "ACC WIFE 1976 WAGES"
    V5291 = "ASSET PART FARM Y 1976"
    V5292 = "ASSET PART BUS Y 1976"
    V5293 = "ASSET PART ROOMERS 1976"
    V5294 = "ALIMONY Y HEAD 1976"
    V5295 = "HEAD RENT,INT,DVIDEND 76"
    V5296 = "WIFE 1976 ASSET Y"
    V5297 = "H+W 1976 TAXABLE Y"
    V5298 = "ACC H+W 1976 ASSET Y"
    V5299 = "H+W 1976 SUPP OTH NONFU"
    V5300 = "H+W 1976 # DEPENDENTS"
    V5301 = "H+W 1976 INCOME TAXES"
    V5302 = "H+W 1976 MARGINAL TAX"
    V5303 = "H+W 1976 ADC,AFDC"
    V5304 = "ACC H+W 1976 ADC,AFDC"
    V5305 = "H+W 1976 OTHER WELFARE"
    V5306 = "H+W 1976 SOCIAL SECURITY"
    V5307 = "HD 1976 OTH RETIREMENT"
    V5308 = "HD 1976 UNEMPLOYMENTCOMP"
    V5309 = "HD 1976 WRKMANS COMP"
    V5310 = "HD 1976 CHILD SUPPORT"
    V5311 = "HD 1976 HELP FRM RELATIV"
    V5312 = "H+W 1976 SSI"
    V5313 = "HEAD OTHER TRANSFER Y"
    V5314 = "WIFE OTHER TRANSFER Y"
    V5315 = "ACC H+W 76 TRANSY NONADC"
    V5316 = "H+W TOT 1976 TRANSFER Y"
    V5317 = "OTH ANNUAL WORK HOURS 76"
    V5318 = "OTH ANNUAL TAXABLE Y 76"
    V5319 = "ACC OTH ANN TAX Y 76"
    V5320 = "BKT OTH 76 ASSET Y"
    V5321 = "OTH 76 TAXES"
    V5322 = "OTH 76 ADC,AFDC $"
    V5323 = "OTH 76 OTR WELFARE $"
    V5324 = "OTH 76 SOCIAL SECURITY $"
    V5325 = "OTH 76 OTR RETIREMENT $"
    V5326 = "OTH 76 UNEMPLOYMENT $"
    V5327 = "OTH 76 WORKMAN COMP $"
    V5328 = "OTH 76 CHILD SUPP $"
    V5329 = "OTH 76 SSI $"
    V5330 = "OTH 76 HELP RELATIV $"
    V5331 = "OTH 76 MISC TRANSFER $"
    V5332 = "OTH 76 TOT TRANSFER $"
    V5333 = "ACC OTH 76 TOT TRANS $"
    V5334 = "# OTH WITH 76 Y"
    V5335 = "# OTH WITH 76 LABOR Y"
    V5336 = "1968 ID"
    V5337 = "1969 ID"
    V5338 = "1970 ID"
    V5339 = "1971 ID"
    V5340 = "1972 ID"
    V5341 = "1973 ID"
    V5342 = "1974 ID"
    V5343 = "1975 ID"
    V5344 = "1976 ID"
    V5345 = "INTR SOC SEC #"
    V5346 = "INTR INT #"
    V5347 = "DATE OF INT"
    V5348 = "LENGTH OF INT"
    V5349 = "# IN FU"
    V5350 = "AGE OF HEAD"
    V5351 = "SEX OF HEAD"
    V5352 = "AGE OF WIFE"
    V5353 = "# KIDS IN FU"
    V5354 = "AGE YNGST KID IN FU"
    V5355 = "KIDS<25 IN FU?        A1"
    V5356 = "KIDS STOP SCHOOL?     A2"
    V5357 = "PUBLIC TRANS NEARBY?  B1"
    V5358 = "WTR PUB TRNS GOOD ENUFB2"
    V5359 = "WTR FAM OWNS CAR/TRUCKB3"
    V5360 = "# CARS/TRUCKS OWNED   B4"
    V5361 = "# MI DRIVEN-ALL CARS  B5"
    V5362 = "ACTUAL # ROOMS        C1"
    V5363 = "TYPE DWELLING         C2"
    V5364 = "OWN/RENT OR WHAT?     C3"
    V5365 = "REASON NEITR OWN/RENTC18"
    V5366 = "MOVED SINCE SPR 1976?C22"
    V5367 = "MO MOVED             C23"
    V5368 = "WHY MOVED            C24"
    V5369 = "WTR MIGHT MOVE       C25"
    V5370 = "LIKELIHOOD OF MOVE   C26"
    V5371 = "WHY MIGHT MOVE       C27"
    V5372 = "WHY MIGHT MOVE (DK)  C28"
    V5373 = "EMPLOYMENT STATUS     D1"
    V5374 = "OCC-2 DIGIT (E)    D2,D3"
    V5375 = "INDUSTRY (E)          D4"
    V5376 = "WORK FOR SELF/OTR?(E) D5"
    V5377 = "WRK FOR GOVT? (OTR)(E)D6"
    V5378 = "# TIMES SUP CHECKS(E) D7"
    V5379 = "WTR SUPV OTRS(OTR)(E) D8"
    V5380 = "# SUPERVISED(OTR)(E)  D9"
    V5381 = "SAY PAY/PROMO?(OTR-E)D10"
    V5382 = "THIS JOB UNION?(OT-E)D11"
    V5383 = "BELONG TO UNION?(O-E)D12"
    V5384 = "# MO WKD EMPLR(OTR-E)D13"
    V5385 = "WRK FOR GOVT? (BTH-E)D14"
    V5386 = "# TIMES SUP CKS(B-E) D15"
    V5387 = "WTR SUPV OTRS(BTH)(E)D16"
    V5388 = "# SUPERVISED (BTH)(E)D17"
    V5389 = "SAY PAY/PROMO?(BTH-E)D18"
    V5390 = "THIS JOB UNION?(BT-E)D19"
    V5391 = "BELONG TO UNION?(B-E)D20"
    V5392 = "# MOS WKD EMPLR(B-E) D21"
    V5393 = "EMPLOY OTRS? (BTH)(E)D22"
    V5394 = "# EMPLOYED   (BTH)(E)D23"
    V5395 = "EMPLOY OTRS? (SELF-E)D24"
    V5396 = "# EMPLOYED(SELF)(E)  D25"
    V5397 = "# MO THIS JOB (E)    D26"
    V5398 = "MO STARTED JOB(E)    D27"
    V5399 = "WHAT HAPND PREV JOB-ED28"
    V5400 = "THIS JOB BETTER?(E)  D29"
    V5401 = "WHY BETTER/WORSE(E)  D30"
    V5402 = "THIS JOB MO $ ? (E)   D31"
    V5403 = "WTR OTRS SICK (E)    D32"
    V5404 = "WHO SICK? (E)        D33"
    V5405 = "# WKS OTRS SICK(E)   D34"
    V5406 = "WTR SELF SICK (E)    D35"
    V5407 = "# WKS SICK-SELF  (E) D36"
    V5408 = "# WKS PD VACATION(E) D37"
    V5409 = "WTR VACATION  (E)    D38"
    V5410 = "# WKS VACATION (E)   D39"
    V5411 = "WTR ON STRIKE (E)    D40"
    V5412 = "# WKS ON STRIKE (E)  D41"
    V5413 = "WTR UNEMPLD (E)      D42"
    V5414 = "# WKS UNEMPLYD (E)   D43"
    V5415 = "UNEMP 1 STRETCH OR(E)D44"
    V5416 = "# PERIODS UNEMP (E)  D45"
    V5417 = "# WKS WORKED (E)     D46"
    V5418 = "HR/WK WORKED (E)     D47"
    V5419 = "WTR WKD OVERTIME (E) D48"
    V5420 = "SALARIED HRLY OR (E) D50"
    V5421 = "PAY/HR SALARY        D51"
    V5422 = "WTR PD OTIME (S)(E)  D52"
    V5423 = "PAY/HR SALARY OT (E) D53"
    V5424 = "PAY/HR HRLY (E)      D54"
    V5425 = "PAY/HR HRLY OT  (E)  D55"
    V5426 = "HOW PAID  (E)        D56"
    V5427 = "PAY/HR OT-OTRS (E)   D57"
    V5428 = "WTR XTRA JOBS        D58"
    V5429 = "OCC-XTRA JOB (E)     D59"
    V5430 = "TOT # XTRA JOBS (E)  D60"
    V5431 = "PAY/HR XTRA JOBS (E) D61"
    V5432 = "WKS WKD-XTRA JOBS(E) D62"
    V5433 = "HR/WK WKD-XTRA JOBS-ED63"
    V5434 = "MORE WRK AVAIL? (E)  D64"
    V5435 = "PAY/HR XTRA WRK(E)   D65"
    V5436 = "WRK MORE IF MORE WRK?D66"
    V5437 = "WRK LESS? (E)        D67"
    V5438 = "WANT LESS WRK? (E)   D68"
    V5439 = "#MI TO WRK (E)       D70"
    V5440 = "MODE JRNY TO WORK (E)D71"
    V5441 = "OCC-JOB SOUGHT (U)   E1"
    V5442 = "PAY/HR-JOB SOUGHT (U)E2"
    V5443 = "WTR NEED TRNG (U)    E3"
    V5444 = "WTR LOOKING FOR JOB-UE4"
    V5445 = "# PLAC LOOK WRK (U)  E5"
    V5446 = "WONT TAKE JOB-LOC?-UE6"
    V5447 = "WONT TAKE JOB-HRS?-UE7"
    V5448 = "JOBS NOT WORTH IT?(U)E8"
    V5449 = "PAY/HR UNWORTHY JOB-UE9"
    V5450 = "WTR MOVE FOR JOB(U) E10"
    V5451 = "PAY/HR TO MOVE(U)   E11"
    V5452 = "WHY NOT MOVE FOR JOBE12"
    V5453 = "# WKS LOOK FOR WRK-UE13"
    V5454 = "EVER HAD JOB?  (U)  E14"
    V5455 = "OCC-LAST JOB (U)    E15"
    V5456 = "IND-LAST JOB (U)    E16"
    V5457 = "WTR SUP OTRS (U)    E17"
    V5458 = "WHAT HAPND JOB (U)  E18"
    V5459 = "YR LAST WRKD (U)     E19"
    V5460 = "WTR VACATION(U)      E20"
    V5461 = "WKS VACATION (U)     E21"
    V5462 = "WTR OTRS ILL (U)     E22"
    V5463 = "WHO ILL (U)          E23"
    V5464 = "# WKS OTRS ILL (U)   E24"
    V5465 = "WTR SELF SICK (U)    E25"
    V5466 = "# WKS ILL-SELF (U)   E26"
    V5467 = "WTR ON STRIKE (U)    E27"
    V5468 = "# WKS ON STRIKE (U)  E28"
    V5469 = "WTR UNEMPLYD (U)     E29"
    V5470 = "# WKS UNEMPLYD (U)   E30"
    V5471 = "UNEMP 1 STRETCH OR(U)E31"
    V5472 = "# PERIODS UNEMP (U)  E32"
    V5473 = "# WKS WKD  (U)       E33"
    V5474 = "HR/ WK WKD (U)       E34"
    V5475 = "# MI TO WORK  (U)    E36"
    V5476 = "MODE JRNY TO WORK (U)E37"
    V5477 = "RET/DIS,HSWF,STUD (R) F1"
    V5478 = "RET FOR HEALTH?       F2"
    V5479 = "WRK FOR MONEY? (R)    F3"
    V5480 = "MIGT GET JOB? (R)     F4"
    V5481 = "WHEN GET JOB   (R)    F5"
    V5482 = "OCCUPATION  (R)       F6"
    V5483 = "INDUSTRY    (R)       F7"
    V5484 = "# WKS WKD   (R)       F8"
    V5485 = "HR/WK WKD   (R)       F9"
    V5486 = "WRKING NOW? (R)      F10"
    V5487 = "WHAT HAPND LAST JOB-RF11"
    V5488 = "MIGHT GET JOB? (R)   F12"
    V5489 = "WHEN GET JOB (R)     F13"
    V5490 = "GET/WONT GET JOB(R)  F14"
    V5491 = "TYPE JOB MIGHT GET(R)F15"
    V5492 = "PAY/HR MIGHT GET(R)  F16"
    V5493 = "NEED TRAINING? (R)   F17"
    V5494 = "HOW GET TRAINING (R) F18"
    V5495 = "GET TRNG NOW? (R)    F19"
    V5496 = "LOOK FOR JOB?        F20"
    V5497 = "# PLAC LOOK FOR JOB  F21"
    V5498 = "WONT TAKE JOB-LOC(R) F22"
    V5499 = "WONT TAKE JOB-HRS?-R F23"
    V5500 = "JOBS NOT WORTH IT?(R)F24"
    V5501 = "PAY/HR UNWORTHY JOBS F25"
    V5502 = "MARITAL STAT          G1"
    V5503 = "EVER MARRIED?         G2"
    V5504 = "WHAT HAPND LAST MARR  G3"
    V5505 = "MARRIED W/WF OR       G4"
    V5506 = "WTR WF WKD            G5"
    V5507 = "OCC-WIFE              G6"
    V5508 = "IND-WIFE              G7"
    V5509 = "WTR OTRS ILL-WF       G8"
    V5510 = "WHO ILL-WF            G9"
    V5511 = "# WKS OTRS ILL       G10"
    V5512 = "WTR WF ILL           G11"
    V5513 = "# WKS WF ILL         G12"
    V5514 = "WTR VACATION-WF      G13"
    V5515 = "# WKS VACATION-WF    G14"
    V5516 = "WTR ON STRIKE-WF     G15"
    V5517 = "# WKS ON STRIKE-WF   G16"
    V5518 = "WTR UNEMP-WF         G17"
    V5519 = "#WKS UNEMP-WF        G18"
    V5520 = "UNEMP 1 STRETCH OR-WFG19"
    V5521 = "# PERIODS UNEMP-WF   G20"
    V5522 = "WKS WKD-WF           G21"
    V5523 = "HR/WK WKD-WF         G22"
    V5524 = "KIDS<12 NOW?         G23"
    V5525 = "WF WK NOW?           G24"
    V5526 = "MODE CH CARE-1ST     G25"
    V5527 = "MODE CH CARE-2ND     G25"
    V5528 = "HR/WK CH CARE        G26"
    V5529 = "WTR PD CH CARE       G27"
    V5530 = "PAY/WK CH CARE       G28"
    V5531 = "# TIMES CH CARE FAILSG29"
    V5532 = "WHO CARED KIDS?      G30"
    V5533 = "HEAD WANT WF WRK?    G31"
    V5534 = "HR/WK WF HSWK        G32"
    V5535 = "HR/WK HD HSWK        G33"
    V5536 = "WTR OTRS HELP W/HSWK G35"
    V5537 = "WTR FD STMPS IN 76   G52"
    V5538 = "WTR ELIG FD STMPS    G56"
    V5539 = "WHY NO FD STMPS      G57"
    V5540 = "TOT FARM RECTS        H2"
    V5541 = "WTR BUSINESS          H5"
    V5542 = "BUS INC OR?           H6"
    V5543 = "WTR WELF/ADC/SUPP Y-HH14"
    V5544 = "WTR WELF HELPED BILLSH15"
    V5545 = "WHAT PAID BY WELF    H16"
    V5546 = "WTR MEDICAID-HD      H17"
    V5547 = "WTR SOC SEC-HD/WF    H24"
    V5548 = "WTR MEDICARE         H25"
    V5549 = "WTR WELF,ETC-OTRS    H41"
    V5550 = "WTR MEDICAID-OTRS    H42"
    V5551 = "WTR SOC SEC-OTRS     H43"
    V5552 = "WTR MEDICARE-OTRS    H44"
    V5553 = "WTR LUMP SUM PYTS    H45"
    V5554 = "$  LUMP SUM PYTS      H46"
    V5555 = "WTR SUPPORT OTRS     H47"
    V5556 = "# SUPPORTED OTRS     H48"
    V5557 = "WTR DEPENDENT OTRS   H50"
    V5558 = "# DEPENDENT OTRS     H51"
    V5559 = "WTR LABOR UNION      H52"
    V5560 = "WTR HEALTH LIMIT     H53"
    V5561 = "HOW MUCH HEALTH LIMITH54"
    V5562 = "WTR 1-PERSON FU      H55"
    V5563 = "WTR OTRS W/XTRA CARE H56"
    V5564 = "REL TO HD-XTRA CARE  H57"
    V5565 = "AGE-OTRS W/XTRA CARE H58"
    V5566 = "WTR NEW WIFE          J1"
    V5567 = "EDUCATION-WF          J2"
    V5568 = "WTR OTR SCHLING-WF    J3"
    V5569 = "TYPE OTR SCHLING-WF   J4"
    V5570 = "WTR BA/BS DEGREE-WF   J6"
    V5571 = "WTR ADVANCED DEGREE-WFJ7"
    V5572 = "EDUC- WF FA           J8"
    V5573 = "EDUC- WF MO           J9"
    V5574 = "# YRS WKD SINCE 18-WFJ10"
    V5575 = "# YRS WKD FULL TIME-WJ11"
    V5576 = "P TIME WKD-WF        J12"
    V5577 = "ACC P TIME WKD-WF    J12"
    V5578 = "WTR NEW HD            K1"
    V5579 = "ST GREW UP-FA OF HD   K2"
    V5580 = "CO GREW UP-FA OF HD   K2"
    V5581 = "ST GREW UP-MO OF HD   K2"
    V5582 = "CO GREW UP-MO OF HD   K2"
    V5583 = "OCC-FATHER OF HD      K3"
    V5584 = "OCC-HDS FIRST JOB     K4"
    V5585 = "# DIFF JOBS OR-HD     K5"
    V5586 = "AGE OLDEST KID-HD  K6-10"
    V5587 = "AGE 2ND OLDEST KID K6-10"
    V5588 = "AGE 3RD OLDEST KID K6-10"
    V5589 = "TOT # OF KIDS-HD   K6-10"
    V5590 = "# KIDS BY 25-HD    K6-10"
    V5591 = "# SIBLINGS-HD        K11"
    V5592 = "WTR OLDER SIBLINGS-HDK12"
    V5593 = "HD GREW UP FARM OR   K13"
    V5594 = "ST GREW UP-HD    K14-K15"
    V5595 = "CO GREW UP-HD    K14-K15"
    V5596 = "# REGIONS LIVED-HD   K16"
    V5597 = "# STATES LIVED-HD    K16"
    V5598 = "EVER MOVED FOR JOB?H K17"
    V5599 = "NOT MOVE FOR JOB?HD  K18"
    V5600 = "PARENTS POOR OR?     K19"
    V5601 = "EDUCATION-HDS FA  K20-21"
    V5602 = "EDUCATION-HDS MO  K22-23"
    V5603 = "WTR VETERAN-HD       K24"
    V5604 = "A YR WKD SINCE 18-HD K25"
    V5605 = "# YR WKD FULL TIME-H K26"
    V5606 = "P TIME WKD-HD        K27"
    V5607 = "ACC P TIME WKD-HD    K27"
    V5608 = "EDUCATION-HD         K28"
    V5609 = "WTR OTR TRNG-HD      K29"
    V5610 = "TYPE OTR TRNG-HD     K30"
    V5611 = "TROUBLE READING? HD  K31"
    V5612 = "WTR OTR SCHOOLING-HD K32"
    V5613 = "TYPE OTR SCHLING-HD  K33"
    V5614 = "WTR BA/BS DEGREE?-HD K35"
    V5615 = "WTR ADVANCED DEGREE-HK36"
    V5616 = "WTR RELIG PREF TAPE-HK37"
    V5617 = "RELIG PREFERENCE-HK38-39"
    V5618 = "WHO RESPONDENT        L1"
    V5619 = "# CALLS               L2"
    V5620 = "INSIDE CITY>50,000?   L3"
    V5621 = "CITY> 50,000 OR MORE  L4"
    V5622 = "DIST TO CNTR CITY     L5"
    V5623 = "CITY>50,000 OR MORE   L6"
    V5624 = "DIST TO CNTR CITY     L7"
    V5625 = "INSIDE CITY>5000?     L8"
    V5626 = "TOT 1976 FAM MONEY INCOM"
    V5627 = "TOT 1976 LABOR INCM HEAD"
    V5628 = "TOT 1976 MISC TRNSF HD/W"
    V5629 = "TOT 76 FAM MNY INCM/NEED"
    V5630 = "ANNUAL FOOD STANDARD"
    V5631 = "1976 AVG HRLY ERNGS-HEAD"
    V5632 = "1976 AVG HRLY ERNGS-WIFE"
    V5633 = "REGION--1977 INTERVIEW"
    V5634 = "REGION 77 HD GRW UP 6-16"
    V5635 = "REGION FTHR 77 HD GRW UP"
    V5636 = "REGION MTHR 77 HD GRW UP"
    V5637 = "GEOGRAPHIC MOBILITY"
    V5638 = "ACURCY 76 MNY INC CMPNTS"
    V5639 = "#MINOR ASSGMTS 77 INTRVW"
    V5640 = "#MAJOR ASSGMTS 77 INTRVW"
    V5641 = "1977 DU VALUE/ROOM"
    V5642 = "ACTUL-REQ RMS FOR FAMILY"
    V5643 = "# PERSONS/ROOM 1977"
    V5644 = "#IN 77 FAMILY 18 OR OLDR"
    V5645 = "BKT V150--AGE OF HEAD"
    V5646 = "BKT V152-AGE OF WIFE"
    V5647 = "EDUCATION OF HEAD"
    V5648 = "EDUCATION OF WIFE"
    V5649 = "76 FDRL INCM TAX CREDIT"
    V5650 = "MARITAL STATUS"
    V5651 = "DECILE:76 FAM MONY INCOM"
    V5652 = "DCILE:76FAM MNY NCM/NEED"
    V5653 = "#CHILDREN AGE 1-2"
    V5654 = "#CHILDREN AGE 3-5"
    V5655 = "#CHILDREN AGE 6-13"
    V5656 = "#FEMALE CHLDRN AGE 14-17"
    V5657 = "#MALE CHLDRN AGE 14-17"
    V5658 = "#FEMALE CHLDRN AGE 18-20"
    V5659 = "#MALE CHLDRN AGE 18-20"
    V5660 = "#FEMALE CHLDRN AGE 21-29"
    V5661 = "#MALE CHLDRN AGE 21-29"
    V5662 = "RACE (FROM 1972 DATA)"
    V5663 = "SPLIT SAMPLE FILTER"
    V5664 = "10 YR CHNGS IN FU COMP"
    V5665 = "1977 FAMILY WEIGHT"
    V5666 = "UNSKL CNTY M LABOR SUPLY"
    V5667 = "UNSKL CNTY F LABOR SUPLY"
    V5668 = "UNSKILLED JOB MARKET -77"
    V5669 = "TYPICAL UNSKILLD WAGE-77"
    V5670 = "DIFF M/F UNSKLD RATE -77"
    V5671 = "UNEMPL RATE IN COUNTY-77"
    V5672 = "1968-69 CHNG MARITAL STA"
    V5673 = "1969-70 CHNG MARITAL STA"
    V5674 = "1970-71 CHNG MARITAL STA"
    V5675 = "1971-72 CHNG MARITAL STA"
    V5676 = "1972-73 CHNG MARITAL STA"
    V5677 = "1973-74 CHNG MARITAL STA"
    V5678 = "1974-75 CHNG MARITAL STA"
    V5679 = "1975-76 CHNG MARITAL STA"
    V5680 = "1976-77 CHNG MARITAL STA"
    V5681 = "HOUSEHOLD ID # 77"
    V5682 = "FU PRIMACY WITHIN HU";

 * USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

 IF V5203=99 THEN V5203=.;
 IF V5204=999 THEN V5204=.;
 IF V5205=99999 THEN V5205=.;
 IF V5206=9 THEN V5206=.;
 IF V5208=9 THEN V5208=.;
 IF V5209=9 THEN V5209=.;
 IF V5212=9 THEN V5212=.;
 IF V5214=9 THEN V5214=.;
 IF V5223=9 THEN V5223=.;
 IF V5224=9999 THEN V5224=.;
 IF V5227=9 THEN V5227=.;
 IF V5228=9 THEN V5228=.;
 IF V5231=9999 THEN V5231=.;
 IF V5258=9999 THEN V5258=.;
 IF V5259=9999 THEN V5259=.;
 IF V5266=9 THEN V5266=.;
 IF V5279=99 THEN V5279=.;
 IF V5299=99999 THEN V5299=.;
 IF V5320=9 THEN V5320=.;
 IF V5350=99 THEN V5350=.;
 IF V5352=99 THEN V5352=.;
 IF V5356=9 THEN V5356=.;
 IF V5357=9 THEN V5357=.;
 IF V5358=9 THEN V5358=.;
 IF V5359=9 THEN V5359=.;
 IF V5360=9 THEN V5360=.;
 IF V5361=99999 THEN V5361=.;
 IF V5362=9 THEN V5362=.;
 IF V5363=9 THEN V5363=.;
 IF V5365=9 THEN V5365=.;
 IF V5366=9 THEN V5366=.;
 IF V5367=99 THEN V5367=.;
 IF V5368=9 THEN V5368=.;
 IF V5369=9 THEN V5369=.;
 IF V5370=9 THEN V5370=.;
 IF V5371=9 THEN V5371=.;
 IF V5372=9 THEN V5372=.;
 IF V5374=99 THEN V5374=.;
 IF V5375=99 THEN V5375=.;
 IF V5376=9 THEN V5376=.;
 IF V5377=9 THEN V5377=.;
 IF V5378=9 THEN V5378=.;
 IF V5379=9 THEN V5379=.;
 IF V5380=99 THEN V5380=.;
 IF V5381=9 THEN V5381=.;
 IF V5382=9 THEN V5382=.;
 IF V5383=9 THEN V5383=.;
 IF V5384=999 THEN V5384=.;
 IF V5385=9 THEN V5385=.;
 IF V5386=9 THEN V5386=.;
 IF V5387=9 THEN V5387=.;
 IF V5388=99 THEN V5388=.;
 IF V5389=9 THEN V5389=.;
 IF V5390=9 THEN V5390=.;
 IF V5391=9 THEN V5391=.;
 IF V5392=999 THEN V5392=.;
 IF V5393=9 THEN V5393=.;
 IF V5394=99 THEN V5394=.;
 IF V5395=9 THEN V5395=.;
 IF V5396=99 THEN V5396=.;
 IF V5397=999 THEN V5397=.;
 IF V5398=99 THEN V5398=.;
 IF V5399=9 THEN V5399=.;
 IF V5400=9 THEN V5400=.;
 IF V5401=9 THEN V5401=.;
 IF V5402=9 THEN V5402=.;
 IF V5403=9 THEN V5403=.;
 IF V5404=9 THEN V5404=.;
 IF V5405=99 THEN V5405=.;
 IF V5406=9 THEN V5406=.;
 IF V5407=99 THEN V5407=.;
 IF V5408=99 THEN V5408=.;
 IF V5409=9 THEN V5409=.;
 IF V5410=99 THEN V5410=.;
 IF V5411=9 THEN V5411=.;
 IF V5412=99 THEN V5412=.;
 IF V5413=9 THEN V5413=.;
 IF V5414=99 THEN V5414=.;
 IF V5415=9 THEN V5415=.;
 IF V5416=9 THEN V5416=.;
 IF V5417=99 THEN V5417=.;
 IF V5418=99 THEN V5418=.;
 IF V5419=9 THEN V5419=.;
 IF V5420=9 THEN V5420=.;
 IF V5421=999 THEN V5421=.;
 IF V5422=9 THEN V5422=.;
 IF V5423=999 THEN V5423=.;
 IF V5424=999 THEN V5424=.;
 IF V5425=999 THEN V5425=.;
 IF V5426=9 THEN V5426=.;
 IF V5427=999 THEN V5427=.;
 IF V5428=9 THEN V5428=.;
 IF V5429=99 THEN V5429=.;
 IF V5430=9 THEN V5430=.;
 IF V5431=999 THEN V5431=.;
 IF V5432=99 THEN V5432=.;
 IF V5433=99 THEN V5433=.;
 IF V5434=9 THEN V5434=.;
 IF V5435=999 THEN V5435=.;
 IF V5436=9 THEN V5436=.;
 IF V5437=9 THEN V5437=.;
 IF V5438=9 THEN V5438=.;
 IF V5439=99 THEN V5439=.;
 IF V5440=9 THEN V5440=.;
 IF V5441=99 THEN V5441=.;
 IF V5442=999 THEN V5442=.;
 IF V5443=9 THEN V5443=.;
 IF V5444=9 THEN V5444=.;
 IF V5445=9 THEN V5445=.;
 IF V5446=9 THEN V5446=.;
 IF V5447=9 THEN V5447=.;
 IF V5448=9 THEN V5448=.;
 IF V5449=999 THEN V5449=.;
 IF V5450=9 THEN V5450=.;
 IF V5451=999 THEN V5451=.;
 IF V5452=9 THEN V5452=.;
 IF V5453=99 THEN V5453=.;
 IF V5454=9 THEN V5454=.;
 IF V5455=99 THEN V5455=.;
 IF V5456=99 THEN V5456=.;
 IF V5457=9 THEN V5457=.;
 IF V5458=9 THEN V5458=.;
 IF V5459=99 THEN V5459=.;
 IF V5460=9 THEN V5460=.;
 IF V5461=99 THEN V5461=.;
 IF V5462=9 THEN V5462=.;
 IF V5463=9 THEN V5463=.;
 IF V5464=99 THEN V5464=.;
 IF V5465=9 THEN V5465=.;
 IF V5466=99 THEN V5466=.;
 IF V5467=9 THEN V5467=.;
 IF V5468=99 THEN V5468=.;
 IF V5469=9 THEN V5469=.;
 IF V5470=99 THEN V5470=.;
 IF V5471=9 THEN V5471=.;
 IF V5472=9 THEN V5472=.;
 IF V5473=99 THEN V5473=.;
 IF V5474=99 THEN V5474=.;
 IF V5475=99 THEN V5475=.;
 IF V5476=9 THEN V5476=.;
 IF V5478=9 THEN V5478=.;
 IF V5479=9 THEN V5479=.;
 IF V5480=9 THEN V5480=.;
 IF V5481=99 THEN V5481=.;
 IF V5482=99 THEN V5482=.;
 IF V5483=99 THEN V5483=.;
 IF V5484=99 THEN V5484=.;
 IF V5485=99 THEN V5485=.;
 IF V5486=9 THEN V5486=.;
 IF V5487=9 THEN V5487=.;
 IF V5488=9 THEN V5488=.;
 IF V5489=99 THEN V5489=.;
 IF V5490=9 THEN V5490=.;
 IF V5491=9 THEN V5491=.;
 IF V5492=999 THEN V5492=.;
 IF V5493=9 THEN V5493=.;
 IF V5494=9 THEN V5494=.;
 IF V5495=9 THEN V5495=.;
 IF V5496=9 THEN V5496=.;
 IF V5497=9 THEN V5497=.;
 IF V5498=9 THEN V5498=.;
 IF V5499=9 THEN V5499=.;
 IF V5500=9 THEN V5500=.;
 IF V5501=999 THEN V5501=.;
 IF V5503=9 THEN V5503=.;
 IF V5504=9 THEN V5504=.;
 IF V5506=9 THEN V5506=.;
 IF V5507=99 THEN V5507=.;
 IF V5508=99 THEN V5508=.;
 IF V5509=9 THEN V5509=.;
 IF V5510=9 THEN V5510=.;
 IF V5511=99 THEN V5511=.;
 IF V5512=9 THEN V5512=.;
 IF V5513=99 THEN V5513=.;
 IF V5514=9 THEN V5514=.;
 IF V5515=99 THEN V5515=.;
 IF V5516=9 THEN V5516=.;
 IF V5517=99 THEN V5517=.;
 IF V5518=9 THEN V5518=.;
 IF V5519=99 THEN V5519=.;
 IF V5520=9 THEN V5520=.;
 IF V5521=9 THEN V5521=.;
 IF V5522=99 THEN V5522=.;
 IF V5523=99 THEN V5523=.;
 IF V5524=9 THEN V5524=.;
 IF V5525=9 THEN V5525=.;
 IF V5528=99 THEN V5528=.;
 IF V5529=9 THEN V5529=.;
 IF V5530=99 THEN V5530=.;
 IF V5531=9 THEN V5531=.;
 IF V5532=9 THEN V5532=.;
 IF V5533=9 THEN V5533=.;
 IF V5534=99 THEN V5534=.;
 IF V5535=99 THEN V5535=.;
 IF V5536=9 THEN V5536=.;
 IF V5537=9 THEN V5537=.;
 IF V5538=9 THEN V5538=.;
 IF V5539=9 THEN V5539=.;
 IF V5540=9 THEN V5540=.;
 IF V5541=9 THEN V5541=.;
 IF V5542=9 THEN V5542=.;
 IF V5543=9 THEN V5543=.;
 IF V5544=9 THEN V5544=.;
 IF V5545=9 THEN V5545=.;
 IF V5546=9 THEN V5546=.;
 IF V5547=9 THEN V5547=.;
 IF V5548=9 THEN V5548=.;
 IF V5549=9 THEN V5549=.;
 IF V5550=9 THEN V5550=.;
 IF V5551=9 THEN V5551=.;
 IF V5552=9 THEN V5552=.;
 IF V5553=9 THEN V5553=.;
 IF V5554=9 THEN V5554=.;
 IF V5555=9 THEN V5555=.;
 IF V5556=9 THEN V5556=.;
 IF V5557=9 THEN V5557=.;
 IF V5558=9 THEN V5558=.;
 IF V5559=9 THEN V5559=.;
 IF V5560=9 THEN V5560=.;
 IF V5561=9 THEN V5561=.;
 IF V5563=9 THEN V5563=.;
 IF V5564=9 THEN V5564=.;
 IF V5565=99 THEN V5565=.;
 IF V5567=99 THEN V5567=.;
 IF V5568=9 THEN V5568=.;
 IF V5569=9 THEN V5569=.;
 IF V5570=9 THEN V5570=.;
 IF V5571=9 THEN V5571=.;
 IF V5572=9 THEN V5572=.;
 IF V5573=9 THEN V5573=.;
 IF V5574=99 THEN V5574=.;
 IF V5575=99 THEN V5575=.;
 IF V5579=99 THEN V5579=.;
 IF V5580=999 THEN V5580=.;
 IF V5581=99 THEN V5581=.;
 IF V5582=999 THEN V5582=.;
 IF V5583=9 THEN V5583=.;
 IF V5584=9 THEN V5584=.;
 IF V5585=9 THEN V5585=.;
 IF V5586=99 THEN V5586=.;
 IF V5587=99 THEN V5587=.;
 IF V5588=99 THEN V5588=.;
 IF V5589=99 THEN V5589=.;
 IF V5590=9 THEN V5590=.;
 IF V5591=9 THEN V5591=.;
 IF V5592=9 THEN V5592=.;
 IF V5593=9 THEN V5593=.;
 IF V5594=99 THEN V5594=.;
 IF V5595=999 THEN V5595=.;
 IF V5596=9 THEN V5596=.;
 IF V5597=9 THEN V5597=.;
 IF V5598=9 THEN V5598=.;
 IF V5599=9 THEN V5599=.;
 IF V5600=9 THEN V5600=.;
 IF V5601=9 THEN V5601=.;
 IF V5602=9 THEN V5602=.;
 IF V5603=9 THEN V5603=.;
 IF V5604=99 THEN V5604=.;
 IF V5605=99 THEN V5605=.;
 IF V5608=99 THEN V5608=.;
 IF V5609=9 THEN V5609=.;
 IF V5610=9 THEN V5610=.;
 IF V5611=9 THEN V5611=.;
 IF V5612=9 THEN V5612=.;
 IF V5613=9 THEN V5613=.;
 IF V5614=9 THEN V5614=.;
 IF V5615=9 THEN V5615=.;
 IF V5616=9 THEN V5616=.;
 IF V5617=9 THEN V5617=.;
 IF V5618=9 THEN V5618=.;
 IF V5619=9 THEN V5619=.;
 IF V5620=9 THEN V5620=.;
 IF V5621=999 THEN V5621=.;
 IF V5622=9 THEN V5622=.;
 IF V5623=999 THEN V5623=.;
 IF V5624=9 THEN V5624=.;
 IF V5625=9 THEN V5625=.;
 IF V5633=9 THEN V5633=.;
 IF V5634=9 THEN V5634=.;
 IF V5635=9 THEN V5635=.;
 IF V5636=9 THEN V5636=.;
 IF V5637=9 THEN V5637=.;
 IF V5641=99999 THEN V5641=.;
 IF V5642=9 THEN V5642=.;
 IF V5643=9.9 THEN V5643=.;
 IF V5645=9 THEN V5645=.;
 IF V5646=9 THEN V5646=.;
 IF V5647=9 THEN V5647=.;
 IF V5648=9 THEN V5648=.;
 IF V5662=9 THEN V5662=.;
 IF V5666=9 THEN V5666=.;
 IF V5667=9 THEN V5667=.;
 IF V5668=9 THEN V5668=.;
 IF V5669=9 THEN V5669=.;
 IF V5670=9 THEN V5670=.;
 IF V5671=9 THEN V5671=.;

file rawdat lrecl=942;
put    
v5202
v5210
v5217
v5218
v5219
v5225
v5226
v5231
v5232
v5233
v5234
v5236
v5244
v5245
v5246
v5248
v5257
v5269
v5270
v5271
v5272
v5273
v5274
v5277
v5278
v5288
v5289
v5290
v5295
v5296
v5297
v5301
v5302
v5316
v5317
v5318
v5320
v5321
v5332
v5347
v5349
v5350
v5351
v5352
v5360
v5364
v5366
v5367
v5368
v5373
v5376
v5384
v5399
v5417
v5418
v5453
v5458
v5473
v5474
v5522
v5523
v5525
v5554
v5556
v5560
v5567
v5570
v5578
v5608
v5614
v5626
v5627
v5633
v5638
v5647
v5648
v5650
v5662
v5665
v30227
;

 proc means;
 run; 
